# Author:   Paul Zandbergen
# Date:     May 22, 2022
# Purpose:  The script determines the number of feature classes in a workspace
#           for each geometry type and the names of those feature classes. The
#           results are written to a text file which automatically opens.

import arcpy
import os

#Variables for paths and workspace
root = "C:/Lessons/PythonDesc"
gdb = "DC.gdb"
textfile = "inventory.txt"
arcpy.env.workspace = os.path.join (root, gdb)
output = os.path.join(root, textfile)

#Create new textfile to write results                  
f = open(output, "w")

#Create list of feature classes by geometry type
points = arcpy.ListFeatureClasses("", "POINT")
lines = arcpy.ListFeatureClasses("", "POLYLINE")
polygons = arcpy.ListFeatureClasses("", "POLYGON")

#Start writing text to output file
f.write(f"Workspace of interest: {arcpy.env.workspace}\n")
f.write(f"This workspace contains the following feature classes:\n")
f.write(f"Count of Point feature classes: {len(points)}\n")
if len(points) != 0:
    f.write(f"The names of the Point feature classes are:\n")
    for point in points:
        desc = arcpy.da.Describe(point)
        f.write(f'\t{desc["baseName"]}\n')
f.write(f"Count of Polyline feature classes: {len(lines)}\n")
if len(lines) != 0:
    f.write(f"The names of the Polyline feature classes are:\n")
    for line in lines:
        desc = arcpy.da.Describe(line)
        f.write(f'\t{desc["baseName"]}\n')
f.write(f"Count of Polygon feature classes: {len(polygons)}\n")
if len(polygons) != 0:
    f.write(f"The names of the Polygon feature classes are:\n")
    for polygon in polygons:
        desc = arcpy.da.Describe(polygon)
        f.write(f'\t{desc["baseName"]}\n')
f.close()

#Open the resulting output file
os.startfile(output)
